<?php

/**
 * Image Thumbnail Builder
 * 
 * @author David Tobin
 * @copyright 2011
 * @version 1.0
 *
 */

class Resizer {
	private $registry;
	
	private $image;
	
	private $newimage;
	
	private $imagetype 	= '';
	
	private $height 	= 0;
	
	private $width		= 0;
	
	private $continue	= true;
	
	public function __construct($registry) {
		$this->registry = $registry;
	}
	
	public function setImageType($type) {
		$this->imagetype = $type;
		
		$this->newimage = imagecreatetruecolor(100, 100);
	}
	
	public function getImage($filename) {
		
		switch ($this->imagetype) {
			case 'gif':
				$image = imagecreatefromgif($filename);
			break;

			case 'png':
				$image = imagecreatefrompng($filename);
			break;
			
			case 'jpeg':
				$image = imagecreatefromjpeg($filename);
			break;
			
			case 'jpg':
				$image = imagecreatefromjpeg($filename);
			break;

			default:
				$this->continue = false;
				
				return false;
			break;	
		}

		$this->image = $image;
		
		return true;
	}
	
	public function setCurrentSize($height, $width) {
		$this->height 	= $height;
		$this->width	= $width;
	}
	
	public function resize($filename) {
		if ($this->continue == true) {

			imagealphablending($this->newimage, false);
			imagesavealpha($this->newimage, true);

			imagecopyresampled($this->newimage, $this->image, 0, 0, 0, 0, 100, 100, $this->width, $this->height);
			imagedestroy($this->image);

			 return $this->output($filename);
		} else {
			return false;
		}
	}
	
	private function output($filename) {
		switch ($this->imagetype) {
			case 'gif':
				return imagegif($this->newimage, $filename);
			break;

			case 'png':
				return imagepng($this->newimage, $filename, 9);
			break;
			
			case 'jpeg':	
				return imagejpeg($this->newimage, $filename, 75);
			break;
			
			case 'jpg':
				return imagejpeg($this->newimage, $filename, 75);
			break;

			default:
				return false;
			break;	
		}
		
	}
}